COLECO:	equ 1
SG1000:	equ 0
MSX:	equ 0
	;
	; CVBasic prologue (BASIC compiler for Colecovision)
	;
	; by Oscar Toledo G.
	; https://nanochess.org/
	;
	; Creation date: Feb/27/2024.
	; Revision date: Feb/29/2024. Turns off sound. Now it reads the controllers.
	;                             Added 16-bit multiply, division, modulo, and abs.
	;                             Added random generator. Added sound routines.
	; Revision date: Mar/03/2024. Removed fname directive to use gasm80.
	; Revision date: Mar/05/2024. Added support for Sega SG1000.
	;

VDP:    equ $98+$26*COLECO+$26*SG1000
JOYSEL:	equ $c0
KEYSEL:	equ $80

PSG:    equ $ff-$80*SG1000
JOY1:   equ $fc-$20*SG1000
JOY2:   equ $ff-$22*SG1000

BASE_RAM: equ $e000-$7000*COLECO-$2000*SG1000

STACK:	equ $e400-$7000*COLECO-$2000*SG1000

    if COLECO
	org $8000
	db $55,$aa
	dw 0
	dw 0
	dw 0
	dw 0
	dw START

	jp 0	; rst $08
	jp 0	; rst $10
	jp 0	; rst $18
	jp 0	; rst $20
	jp 0	; rst $28
	jp 0	; rst $30
	jp 0	; rst $38

	jp nmi_handler
    endif
    if SG1000
	org $0000
	jp START
	db $ff,$ff,$ff,$ff,$ff
	jp 0
	db $ff,$ff,$ff,$ff,$ff
	jp 0
	db $ff,$ff,$ff,$ff,$ff
	jp 0
	db $ff,$ff,$ff,$ff,$ff
	jp 0
	db $ff,$ff,$ff,$ff,$ff
	jp 0
	db $ff,$ff,$ff,$ff,$ff
	jp 0
	db $ff,$ff,$ff,$ff,$ff
	jp nmi_handler	; It should be called int_handler.
	
	db $ff,$ff,$ff,$ff,$ff
	db $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	db $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	db $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	db $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	db $ff,$ff,$ff,$ff,$ff,$ff

	ei		; NMI handler (pause button)
	retn

    endif

WRTVDP:
	ld a,b
	out (VDP+1),a
	ld a,c
	or $80
	out (VDP+1),a
	ret

SETWRT:
	ld a,l
	out (VDP+1),a
	ld a,h
	or $40
	out (VDP+1),a
	ret

SETRD:
	ld a,l
	out (VDP+1),a
	ld a,h
        and $3f
	out (VDP+1),a
	ret

WRTVRM:
	push af
	call SETWRT
	pop af
	out (VDP),a
	ret

RDVRM:
        push af
        call SETRD
        pop af
        ex (sp),hl
        ex (sp),hl
        in a,(VDP)
        ret

FILVRM:
	push af
	call SETWRT
.1:	pop af
	out (VDP),a
	push af
	dec bc
	ld a,b
	or c
	jp nz,.1
	pop af
	ret

LDIRVM:
        EX DE,HL
.1:     LD A,(DE)
        CALL WRTVRM
        INC DE
        INC HL
        DEC BC
        LD A,B
        OR C
        JR NZ,.1
        RET

LDIRVM3:
	call .1
	call .1
.1:	push hl
	push de
	push bc
	call LDIRVM
	pop bc
	pop de
	ld a,d
	add a,8
	ld d,a
	pop hl
	ret

nmi_off:
    if COLECO
	push hl
	ld hl,mode
	set 0,(hl)
	pop hl
    endif
    if SG1000
        di
    endif
	ret

nmi_on:
    if COLECO
	push af
	push hl
	ld hl,mode
	res 0,(hl)
	nop
	bit 1,(hl)
	jp nz,nmi_handler.0
	pop hl
	pop af
    endif
    if SG1000
        ei
    endif
	ret

keypad_table:
        db $0f,$08,$04,$05,$0c,$07,$0a,$02
        db $0d,$0b,$00,$09,$03,$01,$06,$0f

cls:
	ld hl,$1800
	ld (cursor),hl
	ld bc,$0300
	ld a,$20
	call nmi_off
	call FILVRM
	jp nmi_on

print_string:
	ld c,a
	ld b,0
	ld de,(cursor)
	ld a,d
	and $03
	or $18
	ld d,a
	push de
	push bc
	call nmi_off
	call LDIRVM
	call nmi_on
	pop bc
	pop hl
	add hl,bc
	ld (cursor),hl
	ret

print_number:
	ld b,0
	ld de,10000
	call nmi_off
	call .1
	ld de,1000
	call .1
	ld de,100
	call .1
	ld de,10
	call .1
	ld de,1
	inc b
	call .1
	jp nmi_on

.1:	ld a,$2f
	or a
.2:	inc a
	sbc hl,de
	jp nc,.2
	add hl,de
	cp $30
	jr nz,.3
	ld a,b
	or a
	ret z
	ld a,$30
.3:	push hl
	ld hl,(cursor)
	ld c,a
	ld a,h
	and $03
	or $18
	ld h,a
	ld a,c
	call WRTVRM
	inc hl
	ld (cursor),hl
	pop hl
	ld b,1
	ret

define_sprite:
	ex de,hl
	ld l,a
	ld h,0
	add hl,hl	; x2
	add hl,hl	; x4
	add hl,hl	; x8
	add hl,hl	; x16
	add hl,hl	; x32
	ld c,l
	ld b,h
	pop af
	pop hl
	push af
	add hl,hl	; x2
	add hl,hl	; x4
	ld h,$07
	add hl,hl	; x8
	add hl,hl	; x16
	add hl,hl	; x32
	ex de,hl
	call nmi_off
	call LDIRVM
	jp nmi_on
	
define_char:
	ex de,hl
	ld l,a
	ld h,0
	add hl,hl	; x2
	add hl,hl	; x4
	add hl,hl	; x8
	ld c,l
	ld b,h
	pop af
	pop hl
	push af
	add hl,hl	; x2
	add hl,hl	; x4
	add hl,hl	; x8
	ex de,hl
	call nmi_off
	call LDIRVM3
	jp nmi_on
	
define_color:
	ex de,hl
	ld l,a
	ld h,0
	add hl,hl	; x2
	add hl,hl	; x4
	add hl,hl	; x8
	ld c,l
	ld b,h
	pop af
	pop hl
	push af
	add hl,hl	; x2
	add hl,hl	; x4
	add hl,hl	; x8
	ex de,hl
	set 5,d
	call nmi_off
	call LDIRVM3
	jp nmi_on
	
update_sprite:
	pop bc
	ld (sprite_data+3),a
	pop af
	ld (sprite_data+2),a
	pop af
	ld (sprite_data+1),a
	pop af
	ld (sprite_data),a
	pop af
	push bc
	ld de,sprites
	add a,a
	add a,a
	ld e,a
	ld hl,sprite_data
	ld bc,4
	ldir
	ret

	; Fast 16-bit multiplication.
_mul16:
	ld b,h
	ld c,l
	ld a,16
	ld hl,0
.1:
	srl d
	rr e
	jr nc,.2
	add hl,bc
.2:	sla c
	rl b
	dec a
	jp nz,.1
	ret

	; Fast 16-bit division.
_div16:
	ld b,h
	ld c,l
	ld hl,0
	ld a,16
.1:
	rl c
	rl b
	adc hl,hl
	sbc hl,de
	jp nc,.2	
	add hl,de
.2:
	ccf
	dec a
	jp nz,.1
	rl c
	rl b
	ld h,b
	ld l,c
	ret

	; Fast 16-bit modulo.
_mod16:
	ld b,h
	ld c,l
	ld hl,0
	ld a,16
.1:
	rl c
	rl b
	adc hl,hl
	sbc hl,de
	jp nc,.2	
	add hl,de
.2:
	ccf
	dec a
	jp nz,.1
	ret

_abs16:
	bit 7,h
	ret z
	ld a,h
	cpl
	ld h,a
	ld a,l
	cpl
	ld l,a
	inc hl
	ret

	; Random number generator.
	; From my game Mecha Eight.
random:
        ld hl,(lfsr)
        ld a,h
        or l
        jr nz,.0
        ld hl,$7811
.0:     ld a,h
        and $80
        ld b,a
        ld a,h
        and $02
        rrca
        rrca
        xor b
        ld b,a
        ld a,h
        and $01
        rrca
        xor b
        ld b,a
        ld a,l
        and $20
        rlca
        rlca
        xor b
        rlca
        rr h
        rr l
        ld (lfsr),hl
        ret

sn76489_freq:
	ld b,a
	ld a,l
	and $0f
	or b
	out (PSG),a
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,hl
	ld a,h
	and $3f
	out (PSG),a
	ret

sn76489_vol:
	cpl
	and $0f
	or b
	out (PSG),a
	ret

sn76489_control:
	and $0f
	or $e0
	out (PSG),a
	ret

    if SG1000
	; Required for SG1000 as it doesn't have a BIOS
	;
        ; My personal font for TMS9928.
        ;
        ; Patterned after the TMS9928 programming manual 6x8 letters
        ; with better lowercase letters, also I made a proper
        ; AT sign.
        ;
font_bitmaps:
        db $00,$00,$00,$00,$00,$00,$00,$00      ; $20 space
        db $20,$20,$20,$20,$20,$00,$20,$00      ; $21 !
        db $50,$50,$50,$00,$00,$00,$00,$00      ; $22 "
        db $50,$50,$f8,$50,$f8,$50,$50,$00      ; $23 #
        db $20,$78,$a0,$70,$28,$f0,$20,$00      ; $24 $
        db $c0,$c8,$10,$20,$40,$98,$18,$00      ; $25 %
        db $40,$a0,$40,$a0,$a8,$90,$68,$00      ; $26 &
        db $60,$20,$40,$00,$00,$00,$00,$00      ; $27 '
        db $10,$20,$40,$40,$40,$20,$10,$00      ; $28 (
        db $40,$20,$10,$10,$10,$20,$40,$00      ; $29 )
        db $00,$a8,$70,$20,$70,$a8,$00,$00      ; $2a *
        db $00,$20,$20,$f8,$20,$20,$00,$00      ; $2b +
        db $00,$00,$00,$00,$00,$60,$20,$40      ; $2c ,
        db $00,$00,$00,$fc,$00,$00,$00,$00      ; $2d -
        db $00,$00,$00,$00,$00,$00,$60,$00      ; $2e .
        db $00,$08,$10,$20,$40,$80,$00,$00      ; $2f /
        db $70,$88,$98,$a8,$c8,$88,$70,$00      ; $30 0
        db $20,$60,$20,$20,$20,$20,$f8,$00      ; $31 1
        db $70,$88,$08,$10,$60,$80,$f8,$00      ; $32 2
        db $70,$88,$08,$30,$08,$88,$70,$00      ; $33 3
        db $30,$50,$90,$90,$f8,$10,$10,$00      ; $34 4
        db $f8,$80,$f0,$08,$08,$08,$f0,$00      ; $35 5
        db $30,$40,$80,$f0,$88,$88,$70,$00      ; $36 6
        db $f8,$08,$10,$20,$20,$20,$20,$00      ; $37 7
        db $70,$88,$88,$70,$88,$88,$70,$00      ; $38 8
        db $70,$88,$88,$78,$08,$10,$60,$00      ; $39 9
        db $00,$00,$00,$60,$00,$60,$00,$00      ; $3a :
        db $00,$00,$00,$60,$00,$60,$20,$40      ; $3b ;
        db $10,$20,$40,$80,$40,$20,$10,$00      ; $3c <
        db $00,$00,$f8,$00,$f8,$00,$00,$00      ; $3d =
        db $08,$04,$02,$01,$02,$04,$08,$00      ; $3e >
        db $70,$88,$08,$10,$20,$00,$20,$00      ; $3f ?
        db $70,$88,$98,$a8,$98,$80,$70,$00      ; $40 @
        db $20,$50,$88,$88,$f8,$88,$88,$00      ; $41 A
        db $f0,$88,$88,$f0,$88,$88,$f0,$00      ; $42 B
        db $70,$88,$80,$80,$80,$88,$70,$00      ; $43 C
        db $f0,$88,$88,$88,$88,$88,$f0,$00      ; $44 D
        db $f8,$80,$80,$f0,$80,$80,$f8,$00      ; $45 E
        db $f8,$80,$80,$f0,$80,$80,$80,$00      ; $46 F
        db $70,$88,$80,$b8,$88,$88,$70,$00      ; $47 G
        db $88,$88,$88,$f8,$88,$88,$88,$00      ; $48 H
        db $70,$20,$20,$20,$20,$20,$70,$00      ; $49 I
        db $08,$08,$08,$08,$88,$88,$70,$00      ; $4A J
        db $88,$90,$a0,$c0,$a0,$90,$88,$00      ; $4B K
        db $80,$80,$80,$80,$80,$80,$f8,$00      ; $4C L
        db $88,$d8,$a8,$a8,$88,$88,$88,$00      ; $4D M
        db $88,$c8,$c8,$a8,$98,$98,$88,$00      ; $4E N
        db $70,$88,$88,$88,$88,$88,$70,$00      ; $4F O
        db $f0,$88,$88,$f0,$80,$80,$80,$00      ; $50 P
        db $70,$88,$88,$88,$88,$a8,$90,$68      ; $51 Q
        db $f0,$88,$88,$f0,$a0,$90,$88,$00      ; $52 R
        db $70,$88,$80,$70,$08,$88,$70,$00      ; $53 S
        db $f8,$20,$20,$20,$20,$20,$20,$00      ; $54 T
        db $88,$88,$88,$88,$88,$88,$70,$00      ; $55 U
        db $88,$88,$88,$88,$50,$50,$20,$00      ; $56 V
        db $88,$88,$88,$a8,$a8,$d8,$88,$00      ; $57 W
        db $88,$88,$50,$20,$50,$88,$88,$00      ; $58 X
        db $88,$88,$88,$70,$20,$20,$20,$00      ; $59 Y
        db $f8,$08,$10,$20,$40,$80,$f8,$00      ; $5A Z
        db $78,$60,$60,$60,$60,$60,$78,$00      ; $5B [
        db $00,$80,$40,$20,$10,$08,$00,$00      ; $5C \
        db $F0,$30,$30,$30,$30,$30,$F0,$00      ; $5D ]
        db $20,$50,$88,$00,$00,$00,$00,$00      ; $5E 
        db $00,$00,$00,$00,$00,$00,$f8,$00      ; $5F _
        db $40,$20,$10,$00,$00,$00,$00,$00      ; $60 
        db $00,$00,$68,$98,$88,$98,$68,$00      ; $61 a
        db $80,$80,$f0,$88,$88,$88,$f0,$00      ; $62 b
        db $00,$00,$78,$80,$80,$80,$78,$00      ; $63 c
        db $08,$08,$68,$98,$88,$98,$68,$00      ; $64 d
        db $00,$00,$70,$88,$f8,$80,$70,$00      ; $65 e
        db $30,$48,$40,$e0,$40,$40,$40,$00      ; $66 f
        db $00,$00,$78,$88,$88,$78,$08,$70      ; $67 g
        db $80,$80,$f0,$88,$88,$88,$88,$00      ; $68 h
        db $20,$00,$60,$20,$20,$20,$70,$00      ; $69 i
        db $08,$00,$18,$08,$88,$88,$70,$00      ; $6a j
        db $80,$80,$88,$90,$e0,$90,$88,$00      ; $6b k
        db $60,$20,$20,$20,$20,$20,$70,$00      ; $6c l
        db $00,$00,$d0,$a8,$a8,$a8,$a8,$00      ; $6d m
        db $00,$00,$b0,$c8,$88,$88,$88,$00      ; $6e n
        db $00,$00,$70,$88,$88,$88,$70,$00      ; $6f o
        db $00,$00,$f0,$88,$88,$88,$f0,$80      ; $70 p
        db $00,$00,$78,$88,$88,$88,$78,$08      ; $71 q
        db $00,$00,$b8,$c0,$80,$80,$80,$00      ; $72 r
        db $00,$00,$78,$80,$70,$08,$f0,$00      ; $73 s
        db $20,$20,$f8,$20,$20,$20,$20,$00      ; $74 t
        db $00,$00,$88,$88,$88,$98,$68,$00      ; $75 u
        db $00,$00,$88,$88,$88,$50,$20,$00      ; $76 v
        db $00,$00,$88,$a8,$a8,$a8,$50,$00      ; $77 w
        db $00,$00,$88,$50,$20,$50,$88,$00      ; $78 x
        db $00,$00,$88,$88,$98,$68,$08,$70      ; $79 y
        db $00,$00,$f8,$10,$20,$40,$f8,$00      ; $7a z
        db $18,$20,$20,$40,$20,$20,$18,$00      ; $7b {
        db $20,$20,$20,$20,$20,$20,$20,$00      ; $7c |
        db $c0,$20,$20,$10,$20,$20,$c0,$00      ; $7d } 
        db $00,$00,$40,$a8,$10,$00,$00,$00      ; $7e
        db $70,$70,$20,$f8,$20,$70,$50,$00      ; $7f
    endif

START:
	di
	ld sp,STACK
	in a,(VDP+1)
	ld bc,$8201
	call WRTVDP
	in a,(VDP+1)
	ld bc,$8201
	call WRTVDP

	ld hl,(lfsr)	; Save RAM trash for random generator.
	ld de,BASE_RAM
	xor a
	ld (de),a
	inc de
	bit 2,d
	jp z,$-4
	ld (lfsr),hl

    if COLECO
	ld a,($0069)
	cp 50
	ld a,0
	jr z,$+4
	ld a,1
	ld (ntsc),a
    endif
    if SG1000
	ld a,1
	ld (ntsc),a
    endif

	call music_init

	xor a
	ld (mode),a
	ld bc,$0200
	call WRTVDP
	ld bc,$0602	; $1800 for pattern table.
	call WRTVDP
	ld bc,$ff03	; $2000 for color table.
	call WRTVDP
	ld bc,$0304	; $0000 for bitmap table.
	call WRTVDP
	ld bc,$3605	; $1b00 for sprite attribute table.
	call WRTVDP
	ld bc,$0706	; $3800 for sprites bitmaps.
	call WRTVDP

    if COLECO
	ld hl,($006c)
	ld de,-128
	add hl,de
    endif
    if SG1000
	ld hl,font_bitmaps
    endif
	push hl
	ld de,$0100
	ld bc,$0300
	call LDIRVM
	pop hl
	push hl
	ld de,$0900
	ld bc,$0300
	call LDIRVM
	pop hl
	ld de,$1100
	ld bc,$0300
	call LDIRVM
	ld hl,$2000
	ld bc,$1800
	ld a,$f1
	call FILVRM
	ld hl,$1800
	ld bc,$0300
	ld a,$20
	call FILVRM
	ld hl,$1b00
	ld bc,$0080
	ld a,$d1
	call FILVRM
	ld hl,sprites
	ld de,sprites+1
	ld bc,127
	ld (hl),$d1
	ldir
	ld hl,$3800
	ld bc,$0800
	xor a
	call FILVRM

	ld de,$0100
	ld bc,$e201	; Enable screen and interrupts.
	call WRTVDP

	ld a,$ff
	ld (joy1_data),a
	ld (joy2_data),a
	ld a,$0f
	ld (key1_data),a
	ld (key2_data),a

	; CVBasic program start.
	LD HL,128
	PUSH HL
	LD A,21
	LD HL,cvb_GAME_BITMAPS
	CALL define_char
	LD HL,128
	PUSH HL
	LD A,21
	LD HL,cvb_GAME_COLORS
	CALL define_color
	LD HL,0
	PUSH HL
	LD A,10
	LD HL,cvb_GAME_SPRITES
	CALL define_sprite
cvb_RESTART_GAME:
	LD A,2
	LD (cvb_LIVES),A
	LD A,1
	LD (cvb_LEVEL),A
cvb_RESTART_LEVEL:
	LD HL,684
	LD (cursor),HL
	LD HL,cv1
	LD A,7
	CALL print_string
	JP cv2
cv1:
	DB $4c,$69,$76,$65,$73,$3a,$20
cv2:
	LD A,(cvb_LIVES)
	LD L,A
	LD H,0
	CALL print_number
	LD HL,745
	LD (cursor),HL
	LD HL,cv3
	LD A,14
	CALL print_string
	JP cv4
cv3:
	DB $6e,$61,$6e,$6f,$63,$68,$65,$73
	DB $73,$20,$31,$39,$39,$30
cv4:
cvb_NEXT_LEVEL:
	CALL cvb_DRAW_LEVEL
	LD A,8
	LD (cvb_X_PLAYER),A
	LD A,16
	LD (cvb_Y_PLAYER),A
	SUB A
	LD (cvb_PLAYER_FRAME),A
	CALL random
	LD A,L
	AND 127
	LD L,A
	LD H,0
	LD DE,64
	ADD HL,DE
	LD A,L
	LD (cvb_X_ENEMY1),A
	LD A,56
	LD (cvb_Y_ENEMY1),A
	LD A,24
	LD (cvb_ENEMY1_FRAME),A
	CALL random
	LD A,L
	AND 127
	LD L,A
	LD H,0
	LD DE,80
	ADD HL,DE
	LD A,L
	LD (cvb_X_ENEMY2),A
	LD A,96
	LD (cvb_Y_ENEMY2),A
	LD A,32
	LD (cvb_ENEMY2_FRAME),A
	CALL random
	LD A,L
	AND 127
	LD L,A
	LD H,0
	LD DE,48
	ADD HL,DE
	LD A,L
	LD (cvb_X_ENEMY3),A
	LD A,136
	LD (cvb_Y_ENEMY3),A
	LD A,24
	LD (cvb_ENEMY3_FRAME),A
	SUB A
	LD (cvb_ENEMY_SPEED),A
	CALL cvb_START_SONG
cvb_GAME_LOOP:
cv5:
	HALT
	CALL cvb_PLAY_SONG
	SUB A
	PUSH AF
	LD A,(cvb_Y_PLAYER)
	DEC A
	PUSH AF
	LD A,(cvb_X_PLAYER)
	PUSH AF
	LD A,(cvb_PLAYER_FRAME)
	PUSH AF
	LD A,15
	CALL update_sprite
	LD A,1
	PUSH AF
	LD A,(cvb_Y_ENEMY1)
	DEC A
	PUSH AF
	LD A,(cvb_X_ENEMY1)
	PUSH AF
	LD A,(cvb_ENEMY1_FRAME)
	PUSH AF
	LD A,14
	CALL update_sprite
	LD A,2
	PUSH AF
	LD A,(cvb_Y_ENEMY2)
	DEC A
	PUSH AF
	LD A,(cvb_X_ENEMY2)
	PUSH AF
	LD A,(cvb_ENEMY2_FRAME)
	PUSH AF
	LD A,14
	CALL update_sprite
	LD A,3
	PUSH AF
	LD A,(cvb_Y_ENEMY3)
	DEC A
	PUSH AF
	LD A,(cvb_X_ENEMY3)
	PUSH AF
	LD A,(cvb_ENEMY3_FRAME)
	PUSH AF
	LD A,14
	CALL update_sprite
	CALL cvb_MOVE_PLAYER
	LD A,(cvb_LEVEL)
	LD L,A
	LD H,0
	ADD HL,HL
	ADD HL,HL
	LD DE,80
	ADD HL,DE
	LD A,L
	LD (cvb_C),A
	LD A,(cvb_C)
	PUSH AF
	LD A,(cvb_ENEMY_SPEED)
	POP BC
	ADD A,B
	LD (cvb_ENEMY_SPEED),A
cv7:
	LD A,(cvb_ENEMY_SPEED)
	LD L,A
	LD H,0
	LD DE,64
	OR A
	SBC HL,DE
	JP C,cv8
	LD A,(cvb_ENEMY_SPEED)
	SUB 64
	LD (cvb_ENEMY_SPEED),A
	CALL cvb_MOVE_ENEMIES
	JP cv7
cv8:
	LD A,(joy1_data)
	AND 64
	JP Z,cv9
	LD A,(cvb_Y_PLAYER)
	LD L,A
	LD H,0
	LD DE,136
	OR A
	SBC HL,DE
	LD A,0
	JR NZ,$+3
	DEC A
	PUSH AF
	LD A,(cvb_X_PLAYER)
	LD L,A
	LD H,0
	LD DE,248
	OR A
	SBC HL,DE
	LD A,0
	JR NC,$+3
	DEC A
	PUSH AF
	LD A,(cvb_X_PLAYER)
	LD L,A
	LD H,0
	PUSH HL
	LD HL,232
	POP DE
	OR A
	SBC HL,DE
	LD A,0
	JR NC,$+3
	DEC A
	POP BC
	AND B
	POP BC
	AND B
	JP Z,cv10
	CALL cvb_SOUND_OFF
	LD A,1
	LD (cvb_C),A
cv11:
	HALT
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,10
	CALL _mul16
	PUSH HL
	LD HL,200
	POP DE
	OR A
	SBC HL,DE
	LD A,$80
	CALL sn76489_freq
	LD A,13
	LD B,$90
	CALL sn76489_vol
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	LD A,(cvb_C)
	PUSH AF
	LD A,10
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv11
	LD A,(cvb_LEVEL)
	INC A
	LD (cvb_LEVEL),A
	LD A,(cvb_LEVEL)
	LD L,A
	LD H,0
	LD DE,6
	OR A
	SBC HL,DE
	JP NZ,cv12
	CALL cvb_SOUND_OFF
	LD HL,267
	LD (cursor),HL
	LD HL,cv13
	LD A,10
	CALL print_string
	JP cv14
cv13:
	DB $20,$59,$4f,$55,$20,$57,$49,$4e
	DB $21,$20
cv14:
	LD HL,(frame)
	LD (cvb_#C),HL
cv15:
	HALT
	LD HL,(frame)
	LD DE,(cvb_#C)
	OR A
	SBC HL,DE
	LD DE,300
	OR A
	SBC HL,DE
	JP NC,cv17
	JP cv15
cv17:
	LD A,1
	LD (cvb_LEVEL),A
	JP cvb_RESTART_LEVEL
cv12:
	JP cvb_NEXT_LEVEL
cv10:
cv9:
	LD A,(cvb_Y_ENEMY1)
	LD L,A
	LD H,0
	PUSH HL
	LD A,(cvb_Y_PLAYER)
	LD L,A
	LD H,0
	INC HL
	POP DE
	OR A
	SBC HL,DE
	CALL _abs16
	LD DE,8
	OR A
	SBC HL,DE
	JP NC,cv18
	LD A,(cvb_X_ENEMY1)
	LD L,A
	LD H,0
	PUSH HL
	LD A,(cvb_X_PLAYER)
	LD L,A
	LD H,0
	INC HL
	POP DE
	OR A
	SBC HL,DE
	CALL _abs16
	LD DE,8
	OR A
	SBC HL,DE
	JP NC,cv19
	JP cvb_PLAYER_DIES
cv19:
cv18:
	LD A,(cvb_Y_ENEMY2)
	LD L,A
	LD H,0
	PUSH HL
	LD A,(cvb_Y_PLAYER)
	LD L,A
	LD H,0
	INC HL
	POP DE
	OR A
	SBC HL,DE
	CALL _abs16
	LD DE,8
	OR A
	SBC HL,DE
	JP NC,cv20
	LD A,(cvb_X_ENEMY2)
	LD L,A
	LD H,0
	PUSH HL
	LD A,(cvb_X_PLAYER)
	LD L,A
	LD H,0
	INC HL
	POP DE
	OR A
	SBC HL,DE
	CALL _abs16
	LD DE,8
	OR A
	SBC HL,DE
	JP NC,cv21
	JP cvb_PLAYER_DIES
cv21:
cv20:
	LD A,(cvb_Y_ENEMY3)
	LD L,A
	LD H,0
	PUSH HL
	LD A,(cvb_Y_PLAYER)
	LD L,A
	LD H,0
	INC HL
	POP DE
	OR A
	SBC HL,DE
	CALL _abs16
	LD DE,8
	OR A
	SBC HL,DE
	JP NC,cv22
	LD A,(cvb_X_ENEMY3)
	LD L,A
	LD H,0
	PUSH HL
	LD A,(cvb_X_PLAYER)
	LD L,A
	LD H,0
	INC HL
	POP DE
	OR A
	SBC HL,DE
	CALL _abs16
	LD DE,8
	OR A
	SBC HL,DE
	JP NC,cv23
	JP cvb_PLAYER_DIES
cv23:
cv22:
	JP cv5
cv6:
cvb_PLAYER_DIES:
	CALL cvb_SOUND_OFF
	LD HL,640
	LD A,$80
	CALL sn76489_freq
	LD A,13
	LD B,$90
	CALL sn76489_vol
	LD HL,320
	LD A,$a0
	CALL sn76489_freq
	LD A,13
	LD B,$b0
	CALL sn76489_vol
	LD HL,160
	LD A,$c0
	CALL sn76489_freq
	LD A,13
	LD B,$d0
	CALL sn76489_vol
	SUB A
	LD (cvb_PLAYER_FRAME),A
	SUB A
	LD (cvb_C),A
cv24:
	HALT
	HALT
	LD A,(cvb_PLAYER_FRAME)
	XOR 8
	LD (cvb_PLAYER_FRAME),A
	SUB A
	PUSH AF
	LD A,(cvb_Y_PLAYER)
	DEC A
	PUSH AF
	LD A,(cvb_X_PLAYER)
	PUSH AF
	LD A,(cvb_PLAYER_FRAME)
	PUSH AF
	LD A,15
	CALL update_sprite
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	LD A,(cvb_C)
	PUSH AF
	LD A,30
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv24
	CALL cvb_SOUND_OFF
cv25:
	HALT
	LD A,(cvb_Y_PLAYER)
	LD L,A
	LD H,0
	PUSH HL
	LD HL,200
	POP DE
	OR A
	SBC HL,DE
	LD A,$80
	CALL sn76489_freq
	LD A,13
	LD B,$90
	CALL sn76489_vol
	LD A,(cvb_PLAYER_FRAME)
	XOR 8
	LD (cvb_PLAYER_FRAME),A
	SUB A
	PUSH AF
	LD A,(cvb_Y_PLAYER)
	DEC A
	PUSH AF
	LD A,(cvb_X_PLAYER)
	PUSH AF
	LD A,(cvb_PLAYER_FRAME)
	PUSH AF
	LD A,15
	CALL update_sprite
	LD A,(cvb_Y_PLAYER)
	ADD A,2
	LD (cvb_Y_PLAYER),A
	LD A,(cvb_Y_PLAYER)
	LD L,A
	LD H,0
	LD DE,160
	OR A
	SBC HL,DE
	JP NC,cv27
	JP cv25
cv27:
	CALL cvb_SOUND_OFF
	LD A,(cvb_LIVES)
	LD L,A
	LD H,0
	LD DE,0
	OR A
	SBC HL,DE
	JP NZ,cv28
	LD HL,267
	LD (cursor),HL
	LD HL,cv29
	LD A,11
	CALL print_string
	JP cv30
cv29:
	DB $20,$47,$41,$4d,$45,$20,$4f,$56
	DB $45,$52,$20
cv30:
	LD HL,(frame)
	LD (cvb_#C),HL
cv31:
	HALT
	LD HL,(frame)
	LD DE,(cvb_#C)
	OR A
	SBC HL,DE
	LD DE,300
	OR A
	SBC HL,DE
	JP NC,cv33
	JP cv31
cv33:
	JP cvb_RESTART_GAME
cv28:
	LD A,(cvb_LIVES)
	DEC A
	LD (cvb_LIVES),A
	JP cvb_RESTART_LEVEL
cvb_DRAW_LEVEL:
	LD A,(cvb_LEVEL)
	LD L,A
	LD H,0
	DEC HL
	ADD HL,HL
	ADD HL,HL
	LD DE,128
	ADD HL,DE
	LD A,L
	LD (cvb_BASE_CHARACTER),A
	LD HL,6144
	LD (cvb_#C),HL
cv34:
	LD HL,(cvb_#C)
	PUSH HL
	LD A,(cvb_BASE_CHARACTER)
	POP HL
	CALL NMI_OFF
	CALL WRTVRM
	CALL NMI_ON
	LD HL,(cvb_#C)
	INC HL
	PUSH HL
	LD A,(cvb_BASE_CHARACTER)
	POP HL
	CALL NMI_OFF
	CALL WRTVRM
	CALL NMI_ON
	LD HL,(cvb_#C)
	INC HL
	INC HL
	PUSH HL
	LD A,(cvb_BASE_CHARACTER)
	POP HL
	CALL NMI_OFF
	CALL WRTVRM
	CALL NMI_ON
	LD HL,(cvb_#C)
	INC HL
	INC HL
	INC HL
	PUSH HL
	LD A,(cvb_BASE_CHARACTER)
	INC A
	POP HL
	CALL NMI_OFF
	CALL WRTVRM
	CALL NMI_ON
	LD HL,(cvb_#C)
	LD DE,4
	ADD HL,DE
	LD (cvb_#C),HL
	LD HL,6780
	LD DE,(cvb_#C)
	OR A
	SBC HL,DE
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv34
	LD HL,6272
	LD (cvb_#C),HL
cv35:
	LD HL,(cvb_#C)
	LD (cvb_#D),HL
cv36:
	LD HL,(cvb_#D)
	PUSH HL
	LD A,(cvb_BASE_CHARACTER)
	ADD A,2
	POP HL
	CALL NMI_OFF
	CALL WRTVRM
	CALL NMI_ON
	LD HL,(cvb_#D)
	INC HL
	LD (cvb_#D),HL
	LD HL,(cvb_#C)
	LD DE,31
	ADD HL,DE
	LD DE,(cvb_#D)
	OR A
	SBC HL,DE
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv36
	LD HL,(cvb_#C)
	LD DE,160
	ADD HL,DE
	LD (cvb_#C),HL
	LD HL,6752
	LD DE,(cvb_#C)
	OR A
	SBC HL,DE
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv35
	LD A,(cvb_LEVEL)
	LD L,A
	LD H,0
	PUSH HL
	LD HL,6
	POP DE
	OR A
	SBC HL,DE
	LD A,L
	LD (cvb_LADDERS),A
	LD HL,6272
	LD (cvb_#C),HL
cv37:
	LD A,1
	LD (cvb_D),A
cv38:
	CALL random
	LD DE,28
	CALL _mod16
	INC HL
	INC HL
	LD A,L
	LD (cvb_E),A
	LD A,(cvb_E)
	LD L,A
	LD H,0
	PUSH HL
	LD HL,(cvb_#C)
	POP DE
	ADD HL,DE
	PUSH HL
	LD A,(cvb_BASE_CHARACTER)
	ADD A,3
	POP HL
	CALL NMI_OFF
	CALL WRTVRM
	CALL NMI_ON
	LD A,(cvb_E)
	LD L,A
	LD H,0
	PUSH HL
	LD HL,(cvb_#C)
	POP DE
	ADD HL,DE
	LD DE,32
	ADD HL,DE
	PUSH HL
	LD A,(cvb_BASE_CHARACTER)
	ADD A,3
	POP HL
	CALL NMI_OFF
	CALL WRTVRM
	CALL NMI_ON
	LD A,(cvb_E)
	LD L,A
	LD H,0
	PUSH HL
	LD HL,(cvb_#C)
	POP DE
	ADD HL,DE
	LD DE,64
	ADD HL,DE
	PUSH HL
	LD A,(cvb_BASE_CHARACTER)
	ADD A,3
	POP HL
	CALL NMI_OFF
	CALL WRTVRM
	CALL NMI_ON
	LD A,(cvb_E)
	LD L,A
	LD H,0
	PUSH HL
	LD HL,(cvb_#C)
	POP DE
	ADD HL,DE
	LD DE,96
	ADD HL,DE
	PUSH HL
	LD A,(cvb_BASE_CHARACTER)
	ADD A,3
	POP HL
	CALL NMI_OFF
	CALL WRTVRM
	CALL NMI_ON
	LD A,(cvb_E)
	LD L,A
	LD H,0
	PUSH HL
	LD HL,(cvb_#C)
	POP DE
	ADD HL,DE
	LD DE,128
	ADD HL,DE
	PUSH HL
	LD A,(cvb_BASE_CHARACTER)
	ADD A,3
	POP HL
	CALL NMI_OFF
	CALL WRTVRM
	CALL NMI_ON
	LD A,(cvb_D)
	INC A
	LD (cvb_D),A
	LD A,(cvb_D)
	PUSH AF
	LD A,(cvb_LADDERS)
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv38
	LD HL,(cvb_#C)
	LD DE,160
	ADD HL,DE
	LD (cvb_#C),HL
	LD HL,6592
	LD DE,(cvb_#C)
	OR A
	SBC HL,DE
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv37
	LD HL,6750
	PUSH HL
	LD A,148
	POP HL
	CALL NMI_OFF
	CALL WRTVRM
	CALL NMI_ON
	RET
cvb_MOVE_PLAYER:
	LD A,(joy1_data)
	AND 8
	JP Z,cv39
	LD A,(cvb_Y_PLAYER)
	LD L,A
	LD H,0
	LD DE,40
	CALL _mod16
	LD DE,16
	OR A
	SBC HL,DE
	JP NZ,cv40
	LD A,(cvb_X_PLAYER)
	LD L,A
	LD H,0
	PUSH HL
	LD HL,0
	POP DE
	OR A
	SBC HL,DE
	JP NC,cv41
	LD A,(cvb_X_PLAYER)
	DEC A
	LD (cvb_X_PLAYER),A
cv41:
	LD HL,(frame)
	LD A,L
	AND 4
	LD L,A
	LD H,0
	LD A,H
	OR L
	JP Z,cv42
	LD A,8
	LD (cvb_PLAYER_FRAME),A
	JP cv43
cv42:
	LD A,12
	LD (cvb_PLAYER_FRAME),A
cv43:
cv40:
cv39:
	LD A,(joy1_data)
	AND 2
	JP Z,cv44
	LD A,(cvb_Y_PLAYER)
	LD L,A
	LD H,0
	LD DE,40
	CALL _mod16
	LD DE,16
	OR A
	SBC HL,DE
	JP NZ,cv45
	LD A,(cvb_X_PLAYER)
	LD L,A
	LD H,0
	LD DE,240
	OR A
	SBC HL,DE
	JP NC,cv46
	LD A,(cvb_X_PLAYER)
	INC A
	LD (cvb_X_PLAYER),A
cv46:
	LD HL,(frame)
	LD A,L
	AND 4
	LD L,A
	LD H,0
	LD A,H
	OR L
	JP Z,cv47
	SUB A
	LD (cvb_PLAYER_FRAME),A
	JP cv48
cv47:
	LD A,4
	LD (cvb_PLAYER_FRAME),A
cv48:
cv45:
cv44:
	LD A,(joy1_data)
	AND 1
	JP Z,cv49
	LD A,(cvb_Y_PLAYER)
	LD L,A
	LD H,0
	LD DE,40
	CALL _mod16
	LD DE,16
	OR A
	SBC HL,DE
	JP NZ,cv50
	LD A,(cvb_X_PLAYER)
	LD L,A
	LD H,0
	LD DE,7
	ADD HL,DE
	LD DE,8
	CALL _div16
	LD A,L
	LD (cvb_COLUMN),A
	LD A,(cvb_Y_PLAYER)
	LD L,A
	LD H,0
	LD DE,8
	ADD HL,DE
	LD DE,8
	CALL _div16
	LD A,L
	LD (cvb_ROW),A
	LD A,(cvb_COLUMN)
	LD L,A
	LD H,0
	PUSH HL
	LD A,(cvb_ROW)
	LD L,A
	LD H,0
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	LD DE,6144
	ADD HL,DE
	POP DE
	ADD HL,DE
	LD (cvb_#C),HL
	LD A,(cvb_BASE_CHARACTER)
	LD L,A
	LD H,0
	INC HL
	INC HL
	INC HL
	PUSH HL
	LD HL,(cvb_#C)
	CALL nmi_off
	CALL RDVRM
	CALL nmi_on
	LD L,A
	LD H,0
	POP DE
	OR A
	SBC HL,DE
	JP NZ,cv51
	LD A,(cvb_Y_PLAYER)
	DEC A
	LD (cvb_Y_PLAYER),A
cv51:
	JP cv52
cv50:
	LD HL,(frame)
	LD A,L
	AND 4
	LD L,A
	LD H,0
	LD A,H
	OR L
	JP Z,cv53
	LD A,16
	LD (cvb_PLAYER_FRAME),A
	JP cv54
cv53:
	LD A,20
	LD (cvb_PLAYER_FRAME),A
cv54:
	LD A,(cvb_Y_PLAYER)
	DEC A
	LD (cvb_Y_PLAYER),A
cv52:
cv49:
	LD A,(joy1_data)
	AND 4
	JP Z,cv55
	LD A,(cvb_Y_PLAYER)
	LD L,A
	LD H,0
	LD DE,40
	CALL _mod16
	LD DE,16
	OR A
	SBC HL,DE
	JP NZ,cv56
	LD A,(cvb_X_PLAYER)
	LD L,A
	LD H,0
	LD DE,7
	ADD HL,DE
	LD DE,8
	CALL _div16
	LD A,L
	LD (cvb_COLUMN),A
	LD A,(cvb_Y_PLAYER)
	LD L,A
	LD H,0
	LD DE,16
	ADD HL,DE
	LD DE,8
	CALL _div16
	LD A,L
	LD (cvb_ROW),A
	LD A,(cvb_COLUMN)
	LD L,A
	LD H,0
	PUSH HL
	LD A,(cvb_ROW)
	LD L,A
	LD H,0
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	LD DE,6144
	ADD HL,DE
	POP DE
	ADD HL,DE
	LD (cvb_#C),HL
	LD A,(cvb_BASE_CHARACTER)
	LD L,A
	LD H,0
	INC HL
	INC HL
	INC HL
	PUSH HL
	LD HL,(cvb_#C)
	CALL nmi_off
	CALL RDVRM
	CALL nmi_on
	LD L,A
	LD H,0
	POP DE
	OR A
	SBC HL,DE
	JP NZ,cv57
	LD A,(cvb_Y_PLAYER)
	INC A
	LD (cvb_Y_PLAYER),A
cv57:
	JP cv58
cv56:
	LD HL,(frame)
	LD A,L
	AND 4
	LD L,A
	LD H,0
	LD A,H
	OR L
	JP Z,cv59
	LD A,16
	LD (cvb_PLAYER_FRAME),A
	JP cv60
cv59:
	LD A,20
	LD (cvb_PLAYER_FRAME),A
cv60:
	LD A,(cvb_Y_PLAYER)
	INC A
	LD (cvb_Y_PLAYER),A
cv58:
cv55:
	RET
cvb_MOVE_ENEMIES:
	LD A,(cvb_ENEMY1_FRAME)
	LD L,A
	LD H,0
	LD DE,32
	OR A
	SBC HL,DE
	JP NC,cv61
	LD A,(cvb_X_ENEMY1)
	DEC A
	LD (cvb_X_ENEMY1),A
	LD A,(cvb_X_ENEMY1)
	LD L,A
	LD H,0
	LD DE,0
	OR A
	SBC HL,DE
	JP NZ,cv62
	LD A,32
	LD (cvb_ENEMY1_FRAME),A
cv62:
	JP cv63
cv61:
	LD A,(cvb_X_ENEMY1)
	INC A
	LD (cvb_X_ENEMY1),A
	LD A,(cvb_X_ENEMY1)
	LD L,A
	LD H,0
	LD DE,240
	OR A
	SBC HL,DE
	JP NZ,cv64
	LD A,24
	LD (cvb_ENEMY1_FRAME),A
cv64:
cv63:
	LD HL,(frame)
	LD A,L
	AND 4
	LD L,A
	LD H,0
	PUSH HL
	LD A,(cvb_ENEMY1_FRAME)
	LD L,A
	LD H,0
	LD A,L
	AND 248
	LD L,A
	LD H,0
	POP DE
	ADD HL,DE
	LD A,L
	LD (cvb_ENEMY1_FRAME),A
	LD A,(cvb_ENEMY2_FRAME)
	LD L,A
	LD H,0
	LD DE,32
	OR A
	SBC HL,DE
	JP NC,cv65
	LD A,(cvb_X_ENEMY2)
	DEC A
	LD (cvb_X_ENEMY2),A
	LD A,(cvb_X_ENEMY2)
	LD L,A
	LD H,0
	LD DE,0
	OR A
	SBC HL,DE
	JP NZ,cv66
	LD A,32
	LD (cvb_ENEMY2_FRAME),A
cv66:
	JP cv67
cv65:
	LD A,(cvb_X_ENEMY2)
	INC A
	LD (cvb_X_ENEMY2),A
	LD A,(cvb_X_ENEMY2)
	LD L,A
	LD H,0
	LD DE,240
	OR A
	SBC HL,DE
	JP NZ,cv68
	LD A,24
	LD (cvb_ENEMY2_FRAME),A
cv68:
cv67:
	LD HL,(frame)
	LD A,L
	AND 4
	LD L,A
	LD H,0
	PUSH HL
	LD A,(cvb_ENEMY2_FRAME)
	LD L,A
	LD H,0
	LD A,L
	AND 248
	LD L,A
	LD H,0
	POP DE
	ADD HL,DE
	LD A,L
	LD (cvb_ENEMY2_FRAME),A
	LD A,(cvb_ENEMY3_FRAME)
	LD L,A
	LD H,0
	LD DE,32
	OR A
	SBC HL,DE
	JP NC,cv69
	LD A,(cvb_X_ENEMY3)
	DEC A
	LD (cvb_X_ENEMY3),A
	LD A,(cvb_X_ENEMY3)
	LD L,A
	LD H,0
	LD DE,0
	OR A
	SBC HL,DE
	JP NZ,cv70
	LD A,32
	LD (cvb_ENEMY3_FRAME),A
cv70:
	JP cv71
cv69:
	LD A,(cvb_X_ENEMY3)
	INC A
	LD (cvb_X_ENEMY3),A
	LD A,(cvb_X_ENEMY3)
	LD L,A
	LD H,0
	LD DE,240
	OR A
	SBC HL,DE
	JP NZ,cv72
	LD A,24
	LD (cvb_ENEMY3_FRAME),A
cv72:
cv71:
	LD HL,(frame)
	LD A,L
	AND 4
	LD L,A
	LD H,0
	PUSH HL
	LD A,(cvb_ENEMY3_FRAME)
	LD L,A
	LD H,0
	LD A,L
	AND 248
	LD L,A
	LD H,0
	POP DE
	ADD HL,DE
	LD A,L
	LD (cvb_ENEMY3_FRAME),A
	RET
cvb_GAME_BITMAPS:
	DB $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	DB $e7,$e7,$e7,$e7,$e7,$e7,$e7,$e7
	DB $ff,$ff,$00,$ff,$ff,$00,$ff,$ff
	DB $42,$42,$7e,$42,$42,$7e,$42,$42
	DB $fe,$82,$ba,$aa,$ba,$82,$fe,$00
	DB $ba,$ba,$ba,$ba,$ba,$ba,$ba,$ba
	DB $ee,$00,$ff,$ff,$ff,$00,$00,$00
	DB $42,$42,$7e,$42,$42,$7e,$42,$42
	DB $ef,$ef,$ef,$00,$fe,$fe,$fe,$00
	DB $7e,$7e,$7e,$00,$6e,$6e,$6e,$00
	DB $00,$ff,$ff,$aa,$44,$00,$00,$00
	DB $42,$42,$7e,$42,$42,$7e,$42,$42
	DB $ee,$ee,$ee,$00,$ee,$ee,$ee,$00
	DB $40,$30,$0c,$03,$0c,$30,$40,$40
	DB $00,$ff,$00,$aa,$55,$00,$ff,$00
	DB $81,$81,$c3,$bd,$81,$81,$c3,$bd
	DB $81,$58,$37,$47,$39,$27,$49,$27
	DB $47,$49,$27,$40,$28,$15,$12,$27
	DB $00,$fe,$fe,$00,$ef,$ef,$00,$00
	DB $0c,$0c,$18,$18,$30,$30,$18,$18
	DB $54,$fe,$54,$fe,$54,$fe,$54,$00
cvb_GAME_COLORS:
	DB $cc
	DB $cc
	DB $cc
	DB $cc
	DB $cc
	DB $cc
	DB $cc
	DB $cc
	DB $21
	DB $21
	DB $21
	DB $21
	DB $21
	DB $21
	DB $21
	DB $21
	DB $a1
	DB $a1
	DB $a1
	DB $a1
	DB $a1
	DB $a1
	DB $a1
	DB $a1
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $54
	DB $54
	DB $54
	DB $54
	DB $54
	DB $54
	DB $54
	DB $54
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $f1
	DB $11
	DB $e1
	DB $e1
	DB $e1
	DB $11
	DB $11
	DB $11
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $68
	DB $68
	DB $68
	DB $68
	DB $68
	DB $68
	DB $68
	DB $68
	DB $81
	DB $81
	DB $81
	DB $81
	DB $81
	DB $81
	DB $81
	DB $81
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $51
	DB $61
	DB $61
	DB $61
	DB $61
	DB $61
	DB $61
	DB $61
	DB $61
	DB $a1
	DB $a1
	DB $a1
	DB $a1
	DB $a1
	DB $a1
	DB $a1
	DB $a1
	DB $f1
	DB $f1
	DB $f1
	DB $51
	DB $51
	DB $f1
	DB $f1
	DB $f1
	DB $e1
	DB $e1
	DB $e1
	DB $e1
	DB $e1
	DB $e1
	DB $e1
	DB $e1
	DB $86
	DB $86
	DB $86
	DB $86
	DB $86
	DB $86
	DB $86
	DB $86
	DB $2c
	DB $2c
	DB $2c
	DB $2c
	DB $2c
	DB $2c
	DB $2c
	DB $2c
	DB $11
	DB $6e
	DB $6e
	DB $6e
	DB $6e
	DB $6e
	DB $6e
	DB $11
	DB $c1
	DB $c1
	DB $c1
	DB $c1
	DB $c1
	DB $c1
	DB $c1
	DB $c1
	DB $f1
	DB $f1
	DB $f1
	DB $f1
	DB $f1
	DB $f1
	DB $f1
	DB $f1
cvb_GAME_SPRITES:
	DB $00,$01,$05,$03,$07,$03,$07,$1e
	DB $37,$67,$77,$74,$03,$0e,$0e,$0f
	DB $00,$50,$f0,$f0,$d0,$70,$10,$e0
	DB $00,$b8,$b8,$00,$c0,$f8,$7c,$00
	DB $00,$02,$01,$03,$01,$03,$03,$07
	DB $07,$06,$06,$07,$03,$03,$03,$03
	DB $a8,$f8,$f8,$e8,$b8,$88,$70,$80
	DB $c0,$e0,$e0,$00,$c0,$00,$c0,$e0
	DB $00,$0a,$0f,$0f,$0b,$0e,$08,$07
	DB $00,$1d,$1d,$00,$03,$1f,$3e,$00
	DB $00,$80,$a0,$c0,$e0,$c0,$e0,$78
	DB $ec,$e6,$ee,$2e,$c0,$70,$70,$f0
	DB $15,$1f,$1f,$17,$1d,$11,$0e,$01
	DB $03,$07,$07,$00,$03,$00,$03,$07
	DB $00,$40,$80,$c0,$80,$c0,$c0,$e0
	DB $e0,$60,$60,$e0,$c0,$c0,$c0,$c0
	DB $0a,$07,$0f,$0f,$07,$07,$03,$0c
	DB $1b,$70,$73,$02,$06,$06,$1e,$3e
	DB $a0,$c0,$e0,$e0,$ce,$ce,$98,$70
	DB $c0,$00,$c0,$60,$38,$3c,$00,$00
	DB $05,$03,$07,$07,$73,$73,$19,$0e
	DB $03,$00,$03,$06,$1c,$38,$00,$00
	DB $50,$e0,$f0,$f0,$e0,$e0,$c0,$30
	DB $d8,$0e,$ce,$40,$60,$60,$78,$7c
	DB $1b,$2d,$2d,$36,$1f,$7d,$9b,$03
	DB $0f,$1f,$3e,$3c,$3c,$3f,$1f,$0f
	DB $00,$00,$00,$00,$00,$80,$80,$82
	DB $02,$06,$06,$0e,$cc,$ec,$fc,$38
	DB $00,$0d,$16,$16,$1b,$0f,$1e,$5d
	DB $61,$0f,$1f,$1e,$1e,$1f,$0f,$07
	DB $00,$80,$80,$80,$00,$80,$c0,$c0
	DB $c0,$84,$0c,$cc,$d8,$f8,$b8,$30
	DB $00,$00,$00,$00,$00,$01,$01,$41
	DB $40,$60,$60,$70,$33,$37,$3f,$1c
	DB $d8,$b4,$b4,$6c,$f8,$be,$d9,$c0
	DB $f0,$f8,$7c,$3c,$3c,$fc,$f8,$f0
	DB $00,$01,$01,$01,$00,$01,$03,$03
	DB $03,$21,$30,$33,$1b,$1f,$1d,$0c
	DB $00,$b0,$68,$68,$d8,$f0,$78,$ba
	DB $86,$f0,$f8,$78,$78,$f8,$f0,$e0
cvb_START_SONG:
	LD A,8
	LD (cvb_TICK_NOTE),A
	LD A,47
	LD (cvb_SONG_NOTE),A
	RET
cvb_PLAY_SONG:
	LD A,(cvb_TICK_NOTE)
	INC A
	LD (cvb_TICK_NOTE),A
	LD A,(cvb_TICK_NOTE)
	CP 16
	JP NZ,cv73
	SUB A
	LD (cvb_TICK_NOTE),A
	LD A,(cvb_SONG_NOTE)
	INC A
	LD (cvb_SONG_NOTE),A
	LD A,(cvb_SONG_NOTE)
	CP 48
	JP NZ,cv74
	SUB A
	LD (cvb_SONG_NOTE),A
cv74:
	LD A,(cvb_SONG_NOTE)
	LD L,A
	LD H,0
	LD DE,cvb_SONG_NOTES
	ADD HL,DE
	LD A,(HL)
	LD (cvb_NOTE),A
	LD A,(cvb_NOTE)
	LD L,A
	LD H,0
	DEC HL
	ADD HL,HL
	LD DE,cvb_#NOTE_FREQ
	ADD HL,DE
	LD A,(HL)
	INC HL
	LD H,(HL)
	LD L,A
	LD A,$80
	CALL sn76489_freq
cv73:
	LD A,(cvb_TICK_NOTE)
	LD L,A
	LD H,0
	LD DE,cvb_VOLUME_EFFECT
	ADD HL,DE
	LD A,(HL)
	LD B,$90
	CALL sn76489_vol
	RET
cvb_SOUND_OFF:
	SUB A
	LD B,$90
	CALL sn76489_vol
	SUB A
	LD B,$b0
	CALL sn76489_vol
	SUB A
	LD B,$d0
	CALL sn76489_vol
	SUB A
	LD B,$f0
	CALL sn76489_vol
	RET
cvb_VOLUME_EFFECT:
	DB $0b
	DB $0c
	DB $0d
	DB $0c
	DB $0c
	DB $0b
	DB $0b
	DB $0a
	DB $0a
	DB $09
	DB $09
	DB $0a
	DB $0a
	DB $09
	DB $09
	DB $08
cvb_SONG_NOTES:
	DB $01
	DB $02
	DB $03
	DB $04
	DB $05
	DB $04
	DB $03
	DB $02
	DB $01
	DB $02
	DB $03
	DB $04
	DB $05
	DB $04
	DB $03
	DB $02
	DB $06
	DB $04
	DB $07
	DB $08
	DB $09
	DB $08
	DB $07
	DB $04
	DB $06
	DB $04
	DB $07
	DB $08
	DB $09
	DB $08
	DB $07
	DB $04
	DB $03
	DB $0c
	DB $08
	DB $0a
	DB $0b
	DB $0a
	DB $08
	DB $0c
	DB $06
	DB $04
	DB $07
	DB $08
	DB $09
	DB $08
	DB $07
	DB $04
cvb_#NOTE_FREQ:
	DW $01ac
	DW $0153
	DW $011d
	DW $00fe
	DW $00f0
	DW $0140
	DW $00d6
	DW $00be
	DW $00b4
	DW $00aa
	DW $00a0
	DW $00e2
CVBASIC_MUSIC_PLAYER:	equ 0
	;
	; CVBasic epilogue (BASIC compiler for Colecovision)
	;
	; by Oscar Toledo G.
	; https://nanochess.org/
	;
	; Creation date: Feb/27/2024.
	; Revision date: Feb/29/2024. Added joystick, keypad, frame, random, and
	;                             read_pointer variables.
	; Revision date: Mar/04/2024. Added music player.
	; Revision date: Mar/05/2024. Added support for Sega SG1000.
	;

nmi_handler:
	push af
	push hl
	ld hl,mode
	bit 0,(hl)
	jr z,.1
	set 1,(hl)
	pop hl
	pop af
	retn

.0:	res 1,(hl)

.1:	push bc
	push de
	ld hl,$1b00
	call SETWRT
	ld hl,sprites
	ld bc,$8000+VDP
	outi
	jp nz,$-2

    if COLECO
	out (JOYSEL),a
	ex (sp),hl
	ex (sp),hl
	in a,(JOY1)
	or $b0
	ld b,a
	in a,(JOY2)
	or $b0
	ld c,a

	out (KEYSEL),a
	ex (sp),hl
	ex (sp),hl
	in a,(JOY1)
	ld d,a
	in a,(JOY2)
	ld e,a

	ld a,d
	rlca
	or $7f
	and b
	cpl
	ld (joy1_data),a

	ld a,e
	rlca
	or $7f
	and c
	cpl
	ld (joy2_data),a

	ld a,d
	and $0f
	ld c,a
	ld b,0
	ld hl,keypad_table
	add hl,bc
	ld a,(hl)
	ld (key1_data),a

	ld a,e
	and $0f
	ld c,a
	ld hl,keypad_table
	add hl,bc
	ld a,(hl)
	ld (key2_data),a
    endif
    if SG1000
        ld b,$ff
        in a,(JOY1)
        bit 0,a
        jr nz,$+4
        res 0,b
        bit 1,a
        jr nz,$+4
        res 2,b
        bit 2,a
        jr nz,$+4
        res 3,b
        bit 3,a
        jr nz,$+4
        res 1,b
        bit 4,a
        jr nz,$+4
        res 6,b
        bit 5,a
        jr nz,$+4
        res 7,b
	push af
	ld a,b
	cpl
	ld (joy1_data),a
	pop af

	ld b,$ff
        bit 6,a
        jr nz,$+4
        res 0,b
        bit 7,a
        jr nz,$+4
        res 2,b

        in a,(JOY2)
        bit 0,a
        jr nz,$+4
        res 3,b
        bit 1,a
        jr nz,$+4
        res 1,b
        bit 2,a
        jr nz,$+4
        res 4,b
        bit 3,a
        jr nz,$+4
        res 5,b
	push af
	ld a,b
	cpl
	ld (joy2_data),a
	pop af

    endif

    if CVBASIC_MUSIC_PLAYER
	ld a,(music_mode)
	or a
	call nz,music_hardware
    endif

	ld hl,(frame)
	inc hl
	ld (frame),hl

    if CVBASIC_MUSIC_PLAYER
	;
	; Music is played with a 50hz clock.
	;
	ld a,(ntsc)
	or a
	jr z,.2
	ld a,(music_tick)
	inc a
	cp 6
	jr nz,$+3
	xor a
	ld (music_tick),a
	jr z,.3
.2:
	ld a,(music_mode)
	or a
	call nz,music_generate
.3:
    endif

	pop de
	pop bc
	pop hl
	in a,(VDP+1)
	pop af
    if COLECO
	retn
    endif
    if SG1000
        ei
        reti
    endif

	;
	; The music player code comes from my
	; game Princess Quest for Colecovision (2012)
	;

        ;
        ; Init music player.
        ;
music_init:
    if COLECO+SG1000
        ld a,$9f
        out (PSG),a
        ld a,$bf
        out (PSG),a
        ld a,$df
        out (PSG),a
        ld a,$ff
        out (PSG),a
        ld a,$ec
        out (PSG),a
    endif
    if CVBASIC_MUSIC_PLAYER
    else
	ret
    endif

    if CVBASIC_MUSIC_PLAYER
        ld a,$ff
        ld (audio_vol4hw),a
        ld a,$ec
        ld (audio_control),a
        ld a,$b8
        ld (audio_mix),a
	ld hl,music_silence
        ;
	; Play a music.
	; HL = Pointer to music.
        ;
music_play:
        call nmi_off
        ld a,(hl)          
        ld (music_timing),a
        inc hl
        ld (music_start),hl
        ld (music_pointer),hl
        xor a
        ld (music_note_counter),a
	inc a
	ld (music_playing),a
        jp nmi_on

        ;
        ; Reads 4 bytes.
        ;
music_four:
        ld b,(hl)
        inc hl
        ld c,(hl)
        inc hl
        ld d,(hl)
        inc hl
        ld e,(hl)
        ret

        ;
        ; Generates music.
        ;
music_generate:
        ld a,(audio_mix)
        and $c0                 
        or $38
        ld (audio_mix),a
        xor a                ; Turn off all the sound channels.
        ld l,a
        ld h,a
        ld (audio_vol1),hl   ; audio_vol1/audio_vol2
        ld (audio_vol3),a
	ld a,$ff
	ld (audio_vol4hw),a

        ld a,(music_note_counter)
        or a
        jp nz,.6
        ld hl,(music_pointer)
.15:    push hl
        call music_four
        pop hl
        ld a,(music_timing)
        rlca
        jr nc,.16
        ld e,d
        ld d,0
        jr .17

.16:    rlca
        jr nc,.17
        ld e,0
.17:    ld a,b		; Read first byte.
        cp -2           ; End of music?
        jr nz,.19       ; No, jump.
        xor a		; Keep at same place.
        ld (music_playing),a
        ret

.19:    cp -3           ; Repeat music?
        jp nz,.0
        ld hl,(music_start)
        jr .15

.0:     ld a,(music_timing)
        and $3f         ; Restart note time.
        ld (music_note_counter),a
        ld a,b
        cp $3f          ; Sustain?
        jr z,.1
        rlca
        rlca
        and 3
        ld (music_instrument_1),a    
        ld a,b
        and $3f
        ld (music_note_1),a    
        xor a         
        ld (music_counter_1),a    
.1:     ld a,c          
        cp $3f          
        jr z,.2
        rlca
        rlca
        and 3
        ld (music_instrument_2),a    
        ld a,c
        and $3f
        ld (music_note_2),a    
        xor a         
        ld (music_counter_2),a    
.2:     ld a,d          
        cp $3f          
        jr z,.3
        rlca
        rlca
        and 3
        ld (music_instrument_3),a    
        ld a,d
        and $3f
        ld (music_note_3),a    
        xor a         
        ld (music_counter_3),a    
.3:     ld a,e          
        ld (music_drum),a
        xor a
        ld (music_counter_4),a
        inc hl
        inc hl
        inc hl
        ld a,(music_timing)
        and $c0
        jr nz,.14
        inc hl
.14:    ld (music_pointer),hl

.6:     ld a,(music_note_1)    
        or a            
        jr z,.7         
        ld bc,(music_instrument_1)
        call music_note2freq
        ld (audio_freq1),hl 
        ld (audio_vol1),a

.7:     ld a,(music_note_2)    
        or a            
        jr z,.8         
        ld bc,(music_instrument_2)
        call music_note2freq
        ld (audio_freq2),hl 
        ld (audio_vol2),a

.8:     ld a,(music_note_3)    
        or a            
        jr z,.9         
        ld bc,(music_instrument_3)
        call music_note2freq
        ld (audio_freq3),hl 
        ld (audio_vol3),a

.9:     ld a,(music_drum)    
        or a            
        jr z,.4         
        dec a           ; 1 - Long drum.
        jr nz,.5
        ld a,(music_counter_4)
        cp 3
        jp nc,.4
.10:    ld a,5
        ld (audio_noise),a
        call enable_drum
        jr .4

.5:     dec a           ; 2 - Short durm.
        jr nz,.11
        ld a,(music_counter_4)
        or a
        jp nz,.4
        ld a,8
        ld (audio_noise),a
        call enable_drum
        jr .4

.11:    ;dec a           ; 3 - Roll.
        ;jp nz,.4
        ld a,(music_timing)
        and $3e
        rrca
        ld b,a
        ld a,(music_counter_4)
        cp 2
        jp c,.10
        cp b
        jp c,.4
        dec a
        dec a
        cp b
        jp c,.10
.4:
        ld a,(music_counter_1)
        inc a
        cp $18
        jp nz,$+5
        sub $08
        ld (music_counter_1),a

        ld a,(music_counter_2)
        inc a
        cp $18
        jp nz,$+5
        sub $08
        ld (music_counter_2),a

        ld a,(music_counter_3)
        inc a
        cp $18
        jp nz,$+5
        sub $08
        ld (music_counter_3),a

        ld hl,music_counter_4
        inc (hl)
        ld hl,music_note_counter
        dec (hl)
        ret

        ;
        ; Converts note to frequency.
 	; Input:
	;   A = Note (1-62).
	;   B = Instrument counter.
	;   C = Instrument.
        ; Output:
	;   HL = Frequency.
	;   A = Volume.
	;
music_note2freq:
        add a,a
        ld e,a
        ld d,0
        ld hl,music_notes_table
        add hl,de
        ld a,(hl)
        inc hl
        ld h,(hl)
        ld l,a
        ld a,c
        or a
        jp z,music_piano
        dec a
        jp z,music_clarinet
        dec a
        jp z,music_flute
        ;
        ; Bass instrument.
        ;
music_bass:
        add hl,hl

        ;
        ; Piano instrument.
        ;
music_piano:
        ld a,b
        add a,.1&255
        ld c,a
        adc a,.1>>8
        sub c
        ld b,a
        ld a,(bc)
        ret

.1:
        db 12,11,11,10,10,9,9,8
        db 8,7,7,6,6,5,5,4
        db 4,4,5,5,4,4,3,3

        ;
        ; Clarinet instrument.
        ;
music_clarinet:
        ld a,b
        add a,.1&255
        ld c,a
        adc a,.1>>8
        sub c
        ld b,a
        ld a,(bc)
        ld e,a
        rlca
        sbc a,a
        ld d,a
        add hl,de
        srl h           
        rr l
        jp nc,.2
        inc hl
.2:     ld a,c
        add a,24
        ld c,a
        adc a,b
        sub c
        ld b,a
        ld a,(bc)
        ret

.1:
        db 0,0,0,0
        db -2,-4,-2,0
        db 2,4,2,0
        db -2,-4,-2,0
        db 2,4,2,0
        db -2,-4,-2,0

        db 13,14,14,13,13,12,12,12
        db 11,11,11,11,12,12,12,12
        db 11,11,11,11,12,12,12,12

        ;
        ; Flute instrument.
        ;
music_flute:
        ld a,b
        add a,.1&255
        ld c,a
        adc a,.1>>8
        sub c
        ld b,a
        ld a,(bc)
        ld e,a
        rlca
        sbc a,a
        ld d,a
        add hl,de
        ld a,c
        add a,24
        ld c,a
        adc a,b
        sub c
        ld b,a
        ld a,(bc)
        ret

.1:
        db 0,0,0,0
        db 0,1,2,1
        db 0,1,2,1
        db 0,1,2,1
        db 0,1,2,1
        db 0,1,2,1
                 
        db 10,12,13,13,12,12,12,12
        db 11,11,11,11,10,10,10,10
        db 11,11,11,11,10,10,10,10

        ;
        ; Emit sound.
        ;
music_hardware:
    if COLECO+SG1000
	ld a,(music_mode)
	cp 4		; PLAY SIMPLE?
	jr c,.7		; Yes, jump.
        ld a,(audio_vol2)
        or a
        jp nz,.7
        ld a,(audio_vol3)
        or a
        jp z,.7
        ld (audio_vol2),a
        xor a
        ld (audio_vol3),a
        ld hl,(audio_freq3)
        ld (audio_freq2),hl
.7:
        ld hl,(audio_freq1)
        ld a,h
        cp 4
        ld a,$9f
        jp nc,.1
        ld a,l
        and $0f
        or $80
        out (PSG),a
        add hl,hl
        add hl,hl
        add hl,hl
        add hl,hl
        ld a,h
        out (PSG),a
        ld a,(audio_vol1)
        add a,ay2sn and 255
        ld l,a
        adc a,ay2sn>>8
        sub l
        ld h,a
        ld a,(hl)
        or $90
.1:     out (PSG),a

        ld hl,(audio_freq2)
        ld a,h
        cp 4
        ld a,$bf
        jp nc,.2
        ld a,l
        and $0f
        or $a0
        out (PSG),a
        add hl,hl
        add hl,hl
        add hl,hl
        add hl,hl
        ld a,h
        out (PSG),a
        ld a,(audio_vol2)
        add a,ay2sn and 255
        ld l,a
        adc a,ay2sn>>8
        sub l
        ld h,a
        ld a,(hl)
        or $b0
.2:     out (PSG),a

	ld a,(music_mode)
	cp 4		; PLAY SIMPLE?
	jr c,.6		; Yes, jump.

        ld hl,(audio_freq3)
        ld a,h
        cp 4
        ld a,$df
        jp nc,.3
        ld a,l
        and $0f
        or $c0
        out (PSG),a
        add hl,hl
        add hl,hl
        add hl,hl
        add hl,hl
        ld a,h
        out (PSG),a
        ld a,(audio_vol3)
        add a,ay2sn and 255
        ld l,a
        adc a,ay2sn>>8
        sub l
        ld h,a
        ld a,(hl)
        or $d0
.3:     out (PSG),a

.6:
	ld a,(music_mode)
	and 1		; NO DRUMS?
	ret z		; Yes, return.

        ld a,(audio_vol4hw)
        inc a           
        jr z,.4        
        ld a,(audio_noise)
        cp 16
        ld b,$ec        
        jp c,.5
        ld b,$ed        
;       ld b,$ee        
.5:     ld a,(audio_control)
        cp b
        jr z,.4
        ld a,b
        ld (audio_control),a
        out (PSG),a
.4:     ld a,(audio_vol4hw)
        out (PSG),a
        ret
    endif
        ret

        ;
        ; Enable drum.
        ;
enable_drum:
    if COLECO+SG1000
        ld a,$f5
        ld (audio_vol4hw),a
    else
        ld hl,audio_mix
        ld a,(audio_vol2)
        or a
        jr nz,.1
        ld a,10
        ld (audio_vol2),a
        set 1,(hl)
.1:     res 4,(hl)
    endif
        ret

        ;
	; Musical notes table.
	;
music_notes_table:
        ; Silence - 0
        dw 0
        ; 2nd octave - 1
        dw 1721,1621,1532,1434,1364,1286,1216,1141,1076,1017,956,909
        ; 3rd octave - 13
        dw 854,805,761,717,678,639,605,571,538,508,480,453
        ; 4th octave - 25
        dw 427,404,380,360,339,321,302,285,270,254,240,226
        ; 5th octave - 37
        dw 214,202,191,180,170,160,151,143,135,127,120,113
        ; 6th octave - 49
        dw 107,101,95,90,85,80,76,71,67,64,60,57
        ; 7th octave - 61
	dw 54,51,48

    if COLECO+SG1000
        ;
        ; Converts AY-3-8910 volume to SN76489
        ;
ay2sn:
        db $0f,$0f,$0f,$0e,$0e,$0e,$0d,$0b,$0a,$08,$07,$05,$04,$03,$01,$00
    endif

music_silence:
	db 8
	db 0,0,0,0
	db -2
    endif

	org BASE_RAM

sprites:
	rb 128
sprite_data:
	rb 4
frame:
	rb 2
read_pointer:
	rb 2
cursor:
	rb 2
lfsr:
	rb 2
mode:
	rb 1
joy1_data:
	rb 1
joy2_data:
	rb 1
key1_data:
	rb 1
key2_data:
	rb 1
ntsc:
	rb 1

    if CVBASIC_MUSIC_PLAYER
music_tick:             rb 1
music_mode:             rb 1

music_start:		rb 2
music_pointer:		rb 2
music_playing:		rb 1
music_timing:		rb 1
music_note_counter:	rb 1
music_instrument_1:	rb 1
music_counter_1:	rb 1
music_note_1:		rb 1
music_instrument_2:	rb 1
music_counter_2:	rb 1
music_note_2:		rb 1
music_instrument_3:	rb 1
music_counter_3:	rb 1
music_note_3:		rb 1
music_counter_4:	rb 1
music_drum:		rb 1

audio_freq1:		rb 2
audio_freq2:		rb 2
audio_freq3:		rb 2
audio_noise:		rb 1
audio_mix:		rb 1
audio_vol1:		rb 1
audio_vol2:		rb 1
audio_vol3:		rb 1

audio_control:		rb 1
audio_vol4hw:		rb 1
    endif
cvb_Y_ENEMY1:	rb 1
cvb_Y_ENEMY2:	rb 1
cvb_Y_ENEMY3:	rb 1
cvb_C:	rb 1
cvb_D:	rb 1
cvb_E:	rb 1
cvb_PLAYER_FRAME:	rb 1
cvb_TICK_NOTE:	rb 1
cvb_LIVES:	rb 1
cvb_LEVEL:	rb 1
cvb_ENEMY1_FRAME:	rb 1
cvb_COLUMN:	rb 1
cvb_ENEMY_SPEED:	rb 1
cvb_SONG_NOTE:	rb 1
cvb_ENEMY2_FRAME:	rb 1
cvb_#C:	rb 2
cvb_#D:	rb 2
cvb_BASE_CHARACTER:	rb 1
cvb_X_PLAYER:	rb 1
cvb_ENEMY3_FRAME:	rb 1
cvb_X_ENEMY1:	rb 1
cvb_X_ENEMY2:	rb 1
cvb_X_ENEMY3:	rb 1
cvb_NOTE:	rb 1
cvb_LADDERS:	rb 1
cvb_ROW:	rb 1
cvb_Y_PLAYER:	rb 1
